<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Facultad de Medicina Veterinaria de la Universidad Nacional de San Martin - UNSM">
    <meta name="keywords" content="UNSM, Facultad de Medicina Veterinaria, Universidad San Martin, Veterinaria">
    <meta name="author" content="Universidad Nacional de San Martin">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#0288D1">

    <title>Facultad de Medicina Veterinaria - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../css/style.css">
    <!-- Stylesheet Medicina Veterinaria -->
    <link rel="stylesheet" href="css/styleVet.css?v=1.1">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en Facebook" aria-label="Pagina oficial de Facebook de la UNSM">
                    <img src="../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Siguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Siguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../imagenes/logo telefono.png" alt="Telefono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0153</span>
                </span>
                <span>
                    <img src="../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../" aria-label="Ir a la pagina principal de UNSM">
                    <img src="../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martin" width="auto" height="70">
                </a>
            </div>

            <!-- Boton Hamburguesa para movil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menu de navegacion" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegacion principal">
                <div class="mobile-nav-logo">
                    <img src="../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menu Nosotros">
                            <li><a href="../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../nosotros/mision/indexMision.php">Nuestra Mision y Vision</a></li>
                            <li><a href="../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../nosotros/calendarioAcade/indexCale.php">Calendario Academico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menu Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Academico</a></li>
                                <li><a href="../../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigacion</a></li>
                                <li><a href="../../oficinas/secretaria general/indexSecreGene.php">Secretaria General</a></li>
                                <li><a href="../../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicacion e Imagen Institucional</a></li>
                                <li><a href="../../oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperacion y Relaciones Internacionales</a></li>
                                <li><a href="../../oficinas/Organo de Control Institucional/indexOrgaConIns.php">Organo de Control Institucional</a></li>
                                <li><a href="../../oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../../oficinas/Asesoria Juridica/indexAseJuri.php">Asesoria Juridica</a></li>
                                <li><a href="../../oficinas/Grados y Titulos/indexGrados.php">Grados y Titulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Academicas</li>
                                <li><a href="../../oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php">Oficina de Admision</a></li>
                                <li><a href="../../oficinas/Academicos/ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Academicos</a></li>
                                <li><a href="../../oficinas/Academicos/Seguimiento al Egresado e Insercion Laboral/indexSegui.php">Seguimiento al Egresado e Insercion Laboral</a></li>
                                <li><a href="../../oficinas/Academicos/TECNOLOGIAS DE LA INFORMACION/indexOTI.php">Tecnologias de la Informacion</a></li>
                                <li><a href="../../oficinas/Academicos/INCUBADORA DE EMPRESAS/indexIncu.php">Incubadora de Empresas</a></li>
                                <li><a href="../../oficinas/Academicos/FONDO EDITORIAL/indexFondo.php">Fondo Editorial</a></li>
                                <li><a href="../../oficinas/Academicos/COMITE ELECTORAL UNIVERSITARIO/indexComite.php">Comite Electoral Universitario</a></li>
                                <li><a href="../../oficinas/Academicos/INNOVACION Y TRANSFERENCIA TECNOLOGICA/indexInno.php">Innovacion y Transferencia Tecnologica</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../admision/indexAdmin.php">ADMISION</a></li>
                    <li><a href="../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menu Facultades">
                            <li class="has-submenu">
                                <a href="../ciencias agrarias/indexAgra.php" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../ciencias agrarias/agronomia/indexAgro.php">Agronomia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../medicina veterinaria/indexVet.php" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingenieria Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Agroindustrial">
                                    <li><a href="#ing-agroindustrial">Ingenieria Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingenieria Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Civil y Arquitectura">
                                    <li><a href="#arquitectura">Arquitectura</a></li>
                                    <li><a href="#ingenieria-civil-carrera">Ingenieria Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingenieria de Sistemas e Informatica</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria de Sistemas">
                                    <li><a href="#ing-sistemas">Ingenieria de Sistemas e Informatica</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ecologia" aria-haspopup="true" aria-expanded="false">Ecologia</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecologia">
                                    <li><a href="#ing-ambiental">Ingenieria Ambiental</a></li>
                                    <li><a href="#ing-sanitaria">Ingenieria Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Politicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="#medicina-humana-carrera">Medicina Humana</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#educacion" aria-haspopup="true" aria-expanded="false">Educacion y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educacion">
                                    <li><a href="#educacion-inicial">Educacion Inicial</a></li>
                                    <li><a href="#educacion-primaria">Educacion Primaria</a></li>
                                    <li><a href="#educacion-secundaria">Educacion Secundaria</a></li>
                                    <li><a href="#psicologia">Psicologia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Economicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Economicas">
                                    <li><a href="#administracion">Administracion</a></li>
                                    <li><a href="#economia">Economia</a></li>
                                    <li><a href="#contabilidad">Contabilidad</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../#posgrado">POSGRADO</a></li>
                    <li><a href="../../#transparencia">TRANSPARENCIA</a></li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Peru">
                        <img src="../../imagenes/logo gobPe.png" alt="Gobierno del Peru" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Peru">
                    <img src="../../imagenes/logo gobPe.png" alt="Gobierno del Peru" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Facultad -->
    <section class="vet-banner">
        <div class="banner-image">
            <img src="img/banner-veterinaria.jpg" alt="Veterinaria atendiendo a un perro">
        </div>
        <div class="banner-overlay"></div>
        <div class="banner-container">
            <div class="banner-content">
                <div class="facultad-logo">
                    <img src="../../imagenes/Escudos de Facultades — UNSM/MV - UNSM  2021.png" alt="Logo de la Facultad de Medicina Veterinaria" width="150" height="150">
                </div>
                <div class="banner-text">
                    <h1>FACULTAD DE<br>MEDICINA VETERINARIA</h1>
                    <p class="banner-subtitle">Formando profesionales comprometidos con la salud y bienestar animal</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Seccion Facultad con Sidebar -->
    <section class="facultad-section">
        <div class="facultad-container">
            <!-- Contenido Principal -->
            <div class="facultad-main-content">
                <div class="section-badge">
                    <span class="badge-circle">NUESTRA</span>
                    <h2 class="section-title">FACULTAD</h2>
                </div>

                <div class="facultad-content">
                    <p>La Facultad de Medicina Veterinaria de la Universidad Nacional de San Martin forma profesionales altamente capacitados en el cuidado, prevencion y tratamiento de enfermedades en animales. Nuestros egresados estan preparados para contribuir al desarrollo de la ganaderia regional, la salud publica veterinaria y la conservacion de la fauna silvestre de la Amazonia peruana.</p>
                </div>
            </div>

            <!-- Sidebar de Eventos -->
            <aside class="eventos-sidebar">
                <div class="eventos-container">
                    <h3>Proximos Eventos</h3>
                    <p class="no-eventos">No hay nuevos eventos.</p>
                    <div class="eventos-actions">
                        <button class="btn-add">Anadir</button>
                        <a href="#" class="btn-calendar">Ver Calendario &#9654;</a>
                    </div>

                    <div class="contactenos-box">
                        <h4>Contactenos</h4>
                        <p><strong>Campus principal:</strong></p>
                        <p>Jr. Maynas N. 177 - Tarapoto - Peru</p>
                        <p><strong>Telefono:</strong> (+51) (042) 48 0153</p>
                        <p><strong>Email:</strong> informes@unsm.edu.pe</p>
                        <p><strong>Horario:</strong> Lunes a Viernes 7:00am a 2:30pm</p>
                    </div>
                </div>
            </aside>
        </div>
    </section>

    <!-- Carreras Profesionales -->
    <section class="carreras-section">
        <div class="carreras-container">
            <div class="section-badge">
                <span class="badge-circle">NUESTRAS</span>
                <h2 class="section-title">ESCUELAS</h2>
            </div>

            <div class="carreras-grid">
                <!-- Medicina Veterinaria -->
                <div class="carrera-card" id="veterinaria">
                    <div class="carrera-image">
                        <img src="img/escuela-veterinaria.jpg" alt="Estudiantes de Medicina Veterinaria">
                        <div class="carrera-overlay">
                            <h3>VETERINARIA</h3>
                        </div>
                    </div>
                    <div class="carrera-info">
                        <p class="carrera-description">La Escuela Profesional de Medicina Veterinaria forma profesionales capacitados para el diagnostico, tratamiento y prevencion de enfermedades en animales domesticos y silvestres, contribuyendo a la salud publica y el desarrollo pecuario.</p>
                        <a href="#" class="btn-carrera">Ver mas &#8594;</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autonomo y de caracter estatal, comprometido con la formacion de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N. 177 - Morales</p>
                    <p>Tarapoto - San Martin - Peru</p>
                    <p>Central Telefonica: <span>(+51) (042) 48 0153</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rapidos</h3>
                <ul class="footer-links">
                    <li><a href="../../admision/indexAdmin.php">Admision</a></li>
                    <li><a href="../../index.php#facultades">Facultades</a></li>
                    <li><a href="../../index.php#posgrado">Posgrado</a></li>
                    <li><a href="../../index.php#investigacion">Investigacion</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../index.php#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../index.php#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../index.php#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../index.php#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../index.php#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martin - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martin. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Siguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>

    <script src="../../js/script.js" defer></script>
</body>
</html>
